/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Base64;

public class LDIFAttribute
implements Cloneable {
    private String name = null;
    private Vector values = null;
    private int changeType = 5;
    private static final String ENCODING = "UTF8";
    private boolean isBinary = false;

    public LDIFAttribute(String string) {
        this(string, false);
    }

    public LDIFAttribute(String string, boolean bl) {
        this.name = string;
        this.values = new Vector();
        this.isBinary = bl;
    }

    public LDIFAttribute(LDIFAttribute lDIFAttribute) {
        this(lDIFAttribute.name, lDIFAttribute.isBinary);
        int n = lDIFAttribute.values.size();
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = (byte[])lDIFAttribute.values.elementAt(n2);
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.values.addElement(byArray2);
            ++n2;
        }
    }

    public LDIFAttribute(String string, byte[] byArray, boolean bl) {
        this(string, bl);
        this.addValue(byArray);
    }

    public LDIFAttribute(String string, byte[] byArray) {
        this(string, byArray, false);
    }

    public LDIFAttribute(String string, String string2) {
        this(string);
        this.addValue(string2);
    }

    public LDIFAttribute(String string, String[] stringArray) {
        this(string);
        this.setValues(stringArray);
    }

    private static byte[] string2bytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    private static String bytes2string(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getMessage());
        }
        return string;
    }

    public synchronized void addValue(String string) {
        if (string != null) {
            this.values.addElement(LDIFAttribute.string2bytes(string));
        }
    }

    public synchronized void addValue(byte[] byArray) {
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.values.addElement(byArray2);
        }
    }

    public synchronized void addValue(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.values.addElement(LDIFAttribute.string2bytes(stringArray[n]));
                ++n;
            }
        }
    }

    public Enumeration getByteValues() {
        return this.values.elements();
    }

    public Enumeration getStringValues() {
        return new AttributeValueEnumerator(this.values, false);
    }

    public synchronized Enumeration getValsAsObject() {
        return new AttributeValueEnumerator(this.values, this.isBinary());
    }

    public synchronized byte[][] getByteValueArray() {
        byte[][] byArrayArray = null;
        if (this.values.size() != 0) {
            byArrayArray = new byte[this.values.size()][];
            int n = 0;
            while (n < this.values.size()) {
                byte[] byArray = (byte[])this.values.elementAt(n);
                byArrayArray[n] = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArrayArray[n], 0, byArray.length);
                ++n;
            }
        }
        return byArrayArray;
    }

    public synchronized String[] getStringValueArray() {
        String[] stringArray = null;
        if (this.values.size() != 0) {
            stringArray = new String[this.values.size()];
            int n = 0;
            while (n < this.values.size()) {
                if (this.values.elementAt(n) != null) {
                    stringArray[n] = LDIFAttribute.bytes2string((byte[])this.values.elementAt(n));
                }
                ++n;
            }
        }
        return stringArray;
    }

    public synchronized void setValues(String[] stringArray) {
        if (stringArray != null) {
            this.values.removeAllElements();
            int n = 0;
            while (n < stringArray.length) {
                this.values.addElement(LDIFAttribute.string2bytes(stringArray[n]));
                ++n;
            }
        }
    }

    public String getLangSubtype() {
        String[] stringArray = this.getSubtypes();
        String string = null;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n].trim();
                if (string2.length() >= 5 && string2.substring(0, 5).equalsIgnoreCase("lang-")) {
                    string = string2;
                    break;
                }
                ++n;
            }
        }
        return string;
    }

    public static String getBaseName(String string) {
        String string2 = string;
        int n = string.indexOf(";");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public String getBaseName() {
        return LDIFAttribute.getBaseName(this.name);
    }

    public String getName() {
        return this.name;
    }

    public static String[] getSubtypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = null;
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n] = (String)stringTokenizer.nextElement();
                ++n;
            }
        }
        return stringArray;
    }

    public String[] getSubtypes() {
        return LDIFAttribute.getSubtypes(this.name);
    }

    public boolean hasSubtype(String string) {
        String[] stringArray = this.getSubtypes();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.hasSubtype(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized boolean removeValue(String string) {
        boolean bl = false;
        if (string != null && this.values.size() != 0) {
            int n = 0;
            while (n < this.values.size()) {
                String string2 = LDIFAttribute.bytes2string((byte[])this.values.elementAt(n));
                if (string2.equalsIgnoreCase(string)) {
                    this.values.removeElementAt(n);
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public synchronized void removeValue(byte[] byArray) {
        if (byArray != null && this.values.size() != 0) {
            int n = 0;
            while (n < this.values.size()) {
                byte[] byArray2 = (byte[])this.values.elementAt(n);
                if (LDIFAttribute.isEqual(byArray2, byArray)) {
                    this.values.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
    }

    public synchronized void removeAll() {
        this.values.removeAllElements();
    }

    public int size() {
        return this.values.size();
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int n) {
        this.changeType = n;
    }

    public String getValue() {
        String string = null;
        if (this.values.size() > 0) {
            string = LDIFAttribute.bytes2string((byte[])this.values.elementAt(0));
        }
        return string;
    }

    public synchronized boolean contains(String string) {
        if (string == null || this.values.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < this.values.size()) {
            String string2 = LDIFAttribute.bytes2string((byte[])this.values.elementAt(n));
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized boolean contains(byte[] byArray) {
        if (byArray == null || this.values.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < this.values.size()) {
            byte[] byArray2 = (byte[])this.values.elementAt(n);
            if (LDIFAttribute.isEqual(byArray2, byArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Attribute getJNDIAttribute() {
        BasicAttribute basicAttribute = new BasicAttribute(this.name, true);
        int n = 0;
        while (n < this.values.size()) {
            basicAttribute.add(this.values.elementAt(n));
            ++n;
        }
        return basicAttribute;
    }

    public ModificationItem getJNDIModificationItem() {
        Attribute attribute = this.getJNDIAttribute();
        int n = 1;
        if (this.getChangeType() == 7) {
            n = 2;
        } else if (this.getChangeType() == 6) {
            n = 3;
        }
        ModificationItem modificationItem = new ModificationItem(n, attribute);
        return modificationItem;
    }

    private static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getAttributeAsString(boolean bl) {
        return this.getAttributeAsString(bl, true);
    }

    public String getAttributeAsString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        if (this.changeType == 5) {
            stringBuffer.append(LDIFAttribute.getAttrAsLDIFStr("add", this.name, bl, bl2)).append(string);
        } else if (this.changeType == 6) {
            stringBuffer.append(LDIFAttribute.getAttrAsLDIFStr("delete", this.name, bl, bl2)).append(string);
        } else if (this.changeType == 7) {
            stringBuffer.append(LDIFAttribute.getAttrAsLDIFStr("replace", this.name, bl, bl2)).append(string);
        }
        int n = 0;
        while (n < this.values.size()) {
            byte[] byArray = (byte[])this.values.elementAt(n);
            stringBuffer.append(LDIFAttribute.getAttrAsLDIFStr(this.name, byArray, bl, bl2, this.isBinary)).append(string);
            ++n;
        }
        if (bl) {
            stringBuffer.append("#");
        }
        stringBuffer.append("-").append(string);
        return stringBuffer.toString();
    }

    static String getAttrAsLDIFStr(String string, String string2, boolean bl, boolean bl2) {
        return LDIFAttribute.getAttrAsLDIFStr(string, LDIFAttribute.string2bytes(string2), bl, bl2, false);
    }

    static String getAttrAsLDIFStr(String string, byte[] byArray, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        String string3 = "#";
        int n = 77;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl4 = true;
        String string4 = LDIFAttribute.bytes2string(byArray);
        String string5 = ": ";
        if (bl3) {
            byte[] byArray2 = Base64.encode(byArray);
            string5 = ":: " + new String(byArray2);
        } else {
            string5 = string5 + string4;
            if (string4.startsWith(" ") || string4.startsWith(":")) {
                string5 = ":: " + Base64.encode(string4);
            } else {
                int n5 = 0;
                while (n5 < byArray.length) {
                    if (!LDIFAttribute.isAscii(byArray[n5]) || byArray[n5] < 32) {
                        string5 = ":: " + new String(Base64.encode(byArray));
                        break;
                    }
                    ++n5;
                }
            }
        }
        string5 = string + string5;
        n4 = string5.length();
        n3 = Math.min(n4, n);
        if (bl2) {
            while (true) {
                if (bl && bl4) {
                    stringBuffer.append(string3);
                    if (n3 == n) {
                        --n3;
                    }
                    bl4 = false;
                }
                stringBuffer.append(string5.substring(n2, n3));
                n2 = n3;
                n3 = Math.min(n4 - n3, n);
                if (n3 == 0) break;
                stringBuffer.append(string2);
                if (bl) {
                    stringBuffer.append(string3).append(' ');
                    if (n3 == n) {
                        n3 -= 2;
                    }
                } else {
                    stringBuffer.append(' ');
                    if (n3 == n) {
                        --n3;
                    }
                }
                n3 += n2;
            }
            string5 = stringBuffer.toString();
        }
        return string5;
    }

    private static boolean isAscii(byte by) {
        return 0 == (by & 0xFFFFFF80);
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public boolean setBinary(boolean bl) {
        boolean bl2 = this.isBinary;
        this.isBinary = bl;
        return this.isBinary;
    }

    public String toString() {
        return this.getAttributeAsString(false);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LDIFAttribute) {
            bl = this.name.equalsIgnoreCase(((LDIFAttribute)object).name);
        }
        return bl;
    }

    public synchronized Object clone() {
        LDIFAttribute lDIFAttribute = null;
        Enumeration enumeration = null;
        try {
            lDIFAttribute = (LDIFAttribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        lDIFAttribute.name = new String(this.name);
        lDIFAttribute.values = new Vector();
        lDIFAttribute.isBinary = this.isBinary;
        enumeration = this.getByteValues();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            lDIFAttribute.addValue(byArray);
        }
        return lDIFAttribute;
    }

    final class AttributeValueEnumerator
    implements Enumeration {
        Vector vector;
        int count;
        boolean asBinary = false;

        AttributeValueEnumerator(Vector vector, boolean bl) {
            this.vector = vector;
            this.count = 0;
            this.asBinary = bl;
        }

        public boolean hasMoreElements() {
            return this.count < this.vector.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Vector vector = this.vector;
            synchronized (vector) {
                if (this.count < this.vector.size()) {
                    byte[] byArray = (byte[])this.vector.elementAt(this.count++);
                    if (this.asBinary) {
                        byte[] byArray2 = new byte[byArray.length];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        return byArray2;
                    }
                    return LDIFAttribute.bytes2string(byArray);
                }
            }
            throw new NoSuchElementException("Reached End");
        }
    }
}

